package websocket

// Option 配置选项
type Option func(o *Options)

// Options 配置
type Options struct {
	ConnEndpoint     string
	ReadChannelSize  int
	WriteChannelSize int
	Debug            bool
}

// DefaultOptions 默认配置
func DefaultOptions() Options {
	return Options{
		ConnEndpoint:     "",
		ReadChannelSize:  1024,
		WriteChannelSize: 1024,
	}
}

// WithConnEndpoint 设置长连接地址
func WithConnEndpoint(endpoint string) Option {
	return func(o *Options) {
		o.ConnEndpoint = endpoint
	}
}

// WithReadChannelSize 设置读通道大小
func WithReadChannelSize(size int) Option {
	return func(o *Options) {
		o.ReadChannelSize = size
	}
}

// WithWriteChannelSize 设置写通道大小
func WithWriteChannelSize(size int) Option {
	return func(o *Options) {
		o.WriteChannelSize = size
	}
}

// WithDebug 设置调试模式
func WithDebug() Option {
	return func(o *Options) {
		o.Debug = true
	}
}
