package websocket

import (
	"chat-demo-client-golang/event"
)

// ConnType 连接类型
type ConnType uint8

// 连接类型
const (
	ConnTypeAPI ConnType = 5 // API 访客
)

// GetTokenReq 获取连接令牌请求
type GetTokenReq struct {
	Type               ConnType      `json:"type"`
	BotAppKey          string        `json:"bot_app_key"`
	VisitorBizID       string        `json:"visitor_biz_id"`
	VisitorLabels      []event.Label `json:"visitor_labels"`
	TencentCloudDomain string        `json:"tencent_cloud_domain"`
	Scheme             string        `json:"scheme"`
	ReqMethod          string        `json:"req_method"`
	SecretID           string        `json:"secret_id"`
	SecretKey          string        `json:"secret_key"`
	Region             string        `json:"region"`
}

// auth 认证信息
type auth struct {
	Token string `json:"token"`
}

// getTokenRsp 获取连接令牌响应
type getTokenRsp struct {
	Code    int    `json:"code"`
	Message string `json:"message"`
	Data    struct {
		Token string `json:"token"`
	}
}
