// Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package v20231130

import (
	"context"
	"errors"
	"github.com/tencentcloud/tencentcloud-sdk-go/tencentcloud/common"
	tchttp "github.com/tencentcloud/tencentcloud-sdk-go/tencentcloud/common/http"
	"github.com/tencentcloud/tencentcloud-sdk-go/tencentcloud/common/profile"
)

const APIVersion = "2023-11-30"

type Client struct {
	common.Client
}

// NewClientWithSecretId .
func NewClientWithSecretId(secretId, secretKey, region string) (client *Client, err error) {
	cpf := profile.NewClientProfile()
	client = &Client{}
	client.Init(region).WithSecretId(secretId, secretKey).WithProfile(cpf)
	return
}

func NewClient(credential common.CredentialIface, region string, clientProfile *profile.ClientProfile) (client *Client, err error) {
	client = &Client{}
	client.Init(region).
		WithCredential(credential).
		WithProfile(clientProfile)
	return
}

func NewGetWsTokenRequest() (request *GetWsTokenRequest) {
	request = &GetWsTokenRequest{
		BaseRequest: &tchttp.BaseRequest{},
	}

	request.Init().WithApiInfo("lke", APIVersion, "GetWsToken")

	return
}

func NewGetWsTokenResponse() (response *GetWsTokenResponse) {
	response = &GetWsTokenResponse{
		BaseResponse: &tchttp.BaseResponse{},
	}
	return

}

// GetWsToken .
func (c *Client) GetWsToken(request *GetWsTokenRequest) (response *GetWsTokenResponse, err error) {
	return c.GetWsTokenWithContext(context.Background(), request)
}

// GetWsTokenWithContext 获取上下文
func (c *Client) GetWsTokenWithContext(ctx context.Context, request *GetWsTokenRequest) (response *GetWsTokenResponse, err error) {
	if request == nil {
		request = NewGetWsTokenRequest()
	}

	if c.GetCredential() == nil {
		return nil, errors.New("GetWsToken require credential")
	}

	request.SetContext(ctx)

	response = NewGetWsTokenResponse()
	err = c.Send(request, response)
	return
}
