package sse

// Option 配置选项
type Option func(o *Options)

// Options 配置
type Options struct {
	ConnEndpoint string
}

// DefaultOptions 默认配置
func DefaultOptions() Options {
	return Options{
		ConnEndpoint: "",
	}
}

// WithConnEndpoint 设置长连接地址
func WithConnEndpoint(endpoint string) Option {
	return func(o *Options) {
		o.ConnEndpoint = endpoint
	}
}
