package event

import "strings"

// Label 标签
type Label struct {
	Name   string   `json:"name"`
	Values []string `json:"values"`
}

// IsValid 判断标签是否有效
func (l Label) IsValid() bool {
	if strings.TrimSpace(l.Name) == "" || len(l.Values) == 0 {
		return false
	}
	for _, v := range l.Values {
		if strings.TrimSpace(v) == "" {
			return false
		}
	}
	return true
}

// EventSseSend SSE 发送事件
const EventSseSend = "send"

// SseSendEvent SSE 发送事件
type SseSendEvent struct {
	Content           string  `json:"content"`
	BotAppKey         string  `json:"bot_app_key"`
	VisitorBizID      string  `json:"visitor_biz_id"`
	SessionID         string  `json:"session_id"`
	VisitorLabels     []Label `json:"visitor_labels"`
	StreamingThrottle int     `json:"streaming_throttle"`
}

// Name 事件名称
func (e SseSendEvent) Name() string {
	return EventSseSend
}

// IsValid 判断请求是否合法
func (e SseSendEvent) IsValid() bool {
	if e.Content == "" || e.BotAppKey == "" || e.VisitorBizID == "" || e.SessionID == "" {
		return false
	}
	return true
}
