package event

// EventSend 发送事件
const EventSend = "send"

// SendEvent 发送事件消息体
type SendEvent struct {
	RequestID         string `json:"request_id"`
	Content           string `json:"content"`
	SessionID         string `json:"session_id"`
	StreamingThrottle int    `json:"streaming_throttle"`
}

// Name 事件名称
func (e SendEvent) Name() string {
	return EventSend
}

// IsValid 判断事件是否合法
func (e SendEvent) IsValid() bool {
	return e.Content != "" && e.SessionID != ""
}
