package event

// ScoreType 评分类型
type ScoreType uint8

// 评分类型
const (
	ScoreNone     ScoreType = 0
	ScoreUpvote   ScoreType = 1
	ScoreDownvote ScoreType = 2
)

// EventRating 评价事件
const EventRating = "rating"

// RatingEvent 评价事件消息体
type RatingEvent struct {
	RecordID string    `json:"record_id"`
	Score    ScoreType `json:"score"`
	Reasons  []string  `json:"reasons"`
}

// Name 事件名称
func (e RatingEvent) Name() string {
	return EventRating
}

// IsValid 判断事件是否合法
func (e RatingEvent) IsValid() bool {
	if e.RecordID == "" {
		return false
	}
	if e.Score != ScoreUpvote && e.Score != ScoreDownvote {
		return false
	}
	return true
}
