// Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package v20231130

import (
	tcerr "github.com/tencentcloud/tencentcloud-sdk-go/tencentcloud/common/errors"
	tchttp "github.com/tencentcloud/tencentcloud-sdk-go/tencentcloud/common/http"
	"github.com/tencentcloud/tencentcloud-sdk-go/tencentcloud/common/json"
)

type GetWsTokenReq_Label struct {
	// 标签名
	Name *string `json:"Name,omitnil" name:"Name"`

	// 标签值
	Values []*string `json:"Values,omitnil" name:"Values"`
}

// Predefined struct for user
type GetWsTokenRequestParams struct {
	// 接入类型
	Type *int64 `json:"Type,omitnil" name:"Type"`

	// 登录用户主账号(集成商模式必填)
	LoginUin *string `json:"LoginUin,omitnil" name:"LoginUin"`

	// 登录用户子账号(集成商模式必填)
	LoginSubAccountUin *string `json:"LoginSubAccountUin,omitnil" name:"LoginSubAccountUin"`

	// 机器人AppKey
	BotAppKey *string `json:"BotAppKey,omitnil" name:"BotAppKey"`

	// 坐席ID
	VisitorBizId *string `json:"VisitorBizId,omitnil" name:"VisitorBizId"`

	// 坐席标签
	VisitorLabels []*GetWsTokenReq_Label `json:"VisitorLabels,omitnil" name:"VisitorLabels"`
}

type GetWsTokenRequest struct {
	*tchttp.BaseRequest

	// 接入类型
	Type *int64 `json:"Type,omitnil" name:"Type"`

	// 登录用户主账号(集成商模式必填)
	LoginUin *string `json:"LoginUin,omitnil" name:"LoginUin"`

	// 登录用户子账号(集成商模式必填)
	LoginSubAccountUin *string `json:"LoginSubAccountUin,omitnil" name:"LoginSubAccountUin"`

	// 机器人AppKey
	BotAppKey *string `json:"BotAppKey,omitnil" name:"BotAppKey"`

	// 坐席ID
	VisitorBizId *string `json:"VisitorBizId,omitnil" name:"VisitorBizId"`

	// 坐席标签
	VisitorLabels []*GetWsTokenReq_Label `json:"VisitorLabels,omitnil" name:"VisitorLabels"`
}

func (r *GetWsTokenRequest) ToJsonString() string {
	b, _ := json.Marshal(r)
	return string(b)
}

// FromJsonString It is highly **NOT** recommended to use this function
// because it has no param check, nor strict type check
func (r *GetWsTokenRequest) FromJsonString(s string) error {
	f := make(map[string]interface{})
	if err := json.Unmarshal([]byte(s), &f); err != nil {
		return err
	}
	delete(f, "Type")
	delete(f, "LoginUin")
	delete(f, "LoginSubAccountUin")
	delete(f, "BotAppKey")
	delete(f, "VisitorBizId")
	delete(f, "VisitorLabels")
	if len(f) > 0 {
		return tcerr.NewTencentCloudSDKError("ClientError.BuildRequestError", "GetWsTokenRequest has unknown keys!", "")
	}
	return json.Unmarshal([]byte(s), &r)
}

// Predefined struct for user
type GetWsTokenResponseParams struct {
	// token值
	Token *string `json:"Token,omitnil" name:"Token"`

	// 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
	RequestId *string `json:"RequestId,omitnil" name:"RequestId"`
}

type GetWsTokenResponse struct {
	*tchttp.BaseResponse
	Response *GetWsTokenResponseParams `json:"Response"`
}

func (r *GetWsTokenResponse) ToJsonString() string {
	b, _ := json.Marshal(r)
	return string(b)
}

// FromJsonString It is highly **NOT** recommended to use this function
// because it has no param check, nor strict type check
func (r *GetWsTokenResponse) FromJsonString(s string) error {
	return json.Unmarshal([]byte(s), &r)
}
